/*
 *
 *                             C@@o         ____  _____   __ _
 *                        oC8@@@@@@@o      |___ \|  __ \ / _| |
 *                    o@@@@@@@@@@@@O         __) | |  | | |_| | _____      __
 *         O@O        8@@@@@@@@@O           |__ <| |  | |  _| |/ _ \ \ /\ / /
 *       o@@@@@@@O    OOOOOCo               ___) | |__| | | | | (_) \ V  V /
 *       C@@@@@@@@@@@@Oo                   |____/|_____/|_| |_|\___/ \_/\_/
 *          o8@@@@@@@@@@@@@@@@8OOCCCC
 *              oO@@@@@@@@@@@@@@@@@@@o          3Dflow s.r.l. - www.3dflow.net
 *                   oO8@@@@@@@@@@@@o           Copyright 2022
 *       oO88@@@@@@@@8OCo                       All Rights Reserved
 *  O@@@@@@@@@@@@@@@@@@@@@@@@@8OCCoooooooCCo
 *   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@O
 *    @@@Oo            oO8@@@@@@@@@@@@@@@@8
 *
 */

#ifndef FLOWENGINEENTITYINTERFACE_H
#define FLOWENGINEENTITYINTERFACE_H

#pragma once

#include "CommonDef.h"

namespace FlowEngine
{
    //! Interface for all FlowEngine objects with an editable name.
    class NamedObjectInterface
    {
        public:

            //! Default virtual destructor.
            FLE_DLL virtual ~NamedObjectInterface() = default;

        public:

            //! @returns the length of the name of this entity.
            FLE_DLL virtual Size getNameLength() const = 0;

            //! @returns the length of the name of this entity.
            //! @param outName a buffer that receives the name of the entity. Must be at least getNameLength() long.
            //! @returns One of the following result codes:
            //! - Result::Success -- if the buffer was successfully filled with the entity name.
            //! - Result::InvalidArgument -- if `outName` is not a valid string buffer.
            //! - Result::BufferTooSmall -- if `outName` is not big enough.
            FLE_DLL virtual Result getName( StringBuffer outName ) const = 0;

            //! Set the name of this entity.
            //! @param name a constant string buffer containing the name of the entity
            //! @returns One of the following result codes:
            //! - Result::Success -- if the entity name was successfully changed.
            //! - Result::InvalidArgument -- if `name` is not a valid string buffer.
            FLE_DLL virtual Result setName( ConstStringBuffer name ) = 0;
    };
}

#endif
